package com.izenpe.zain.cliente.pdf;

import java.io.FileInputStream;
import java.io.InputStream;

import org.apache.axis.encoding.Base64;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;
import org.apache.axis.utils.XMLUtils;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.AnyType;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.OptionalInputs;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Properties;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.PropertiesType;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Property;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignRequest;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartSignRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartSignResponse;

public class GeneracionFirmaPDFPlantillaXml {
	// Nombre del fichero a utilizar para la Generacin de la firma PDF.
	private static final String fileName = "PruebaPDF.pdf";

	public static void main(String[] args) {
		try {
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartSignRequest smartSignReq = new SmartSignRequest(Propiedades.ZAIN_ENDPOINT);

			// Se establece el perfil de firma PDF en la peticin de Generacin
			// de firma.
			smartSignReq.setProfile(Constants.Profile.PDF);

			/*
			 * Se establece el idioma de la peticin en espaol. 2
			 * posibilidades: 1. Espaol: 'es' 2. Ingls: 'en'
			 */
			smartSignReq.setLanguage("es");

			/*
			 * Cuando este elemento se omite, la firma no incluye el atributo
			 * signingcertificate. Esto es, el formato de la firma no puede
			 * considerarse equivalente al formato PKCS #7 de una firma
			 * CAdES-BES (y por tanto es una firma NoAdES).
			 */
			smartSignReq.setSignatureFormat(Constants.SignatureFormat.ES_T);

			// Certificado con el que realizar la firma.
			smartSignReq.setKeySubjectName(Propiedades.ZAIN_SIGNER);

			// Datos a firmar.
			smartSignReq.setInputPdfBase64Data(Base64.encode(ZainUtil.readBinaryFile("data/input/" + fileName)));

			// Asignacin de una plantilla
			SignRequest signReq = (SignRequest) smartSignReq.getInternalObject();
			OptionalInputs optionalInputs = signReq.getOptionalInputs();

			Properties props = new Properties();
			PropertiesType signedProp = new PropertiesType();
			Property prop = new Property();
			prop.setIdentifier(new URI("urn:safelayer:tws:dss:1.0:property:pdfattributes"));

			InputStream plantillaPdf = new FileInputStream("resources/plantilla-pdf.xml");
			org.w3c.dom.Document document = XMLUtils.newDocument(plantillaPdf);
			MessageElement messageElement = new MessageElement(document.getDocumentElement());
			AnyType XMLData = new AnyType(new MessageElement[] { messageElement });
			prop.setValue(XMLData);

			signedProp.setProperty(new Property[] { prop });
			props.setSignedProperties(signedProp);

			optionalInputs.setProperties(props);
			// Fin asignacin plantilla

			// Envo de la peticin.
			SmartSignResponse smartSignResp = smartSignReq.send();

			/*
			 * Se comprueba la validez de la respuesta y se escribe la respuesta
			 * de Generacin de firma PDF en un fichero en disco.
			 */
			if (Constantes.RMAJOR_SUCCESS.equals((smartSignResp.getResultMajor()))
					&& smartSignResp.getResultMinor() == null) {
				String docPDF = smartSignResp.getDocumentWithSignaturePdf();
				byte[] data = Base64.decode(docPDF);
				String destFilename = "data/output/" + fileName.substring(0, fileName.lastIndexOf(".")) + "SignedConPlantilla.pdf";
				ZainUtil.writeBinaryFile(destFilename, data);
				System.out.println("La firma ha sido generada con xito");
			} else {
				System.out.println("Error en la Generacin de Firma:" + smartSignResp.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}